/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.diffpatch.cli;

import io.codechicken.diffpatch.cli.CliOperation;
import io.codechicken.diffpatch.diff.Differ;
import io.codechicken.diffpatch.diff.PatienceDiffer;
import io.codechicken.diffpatch.util.ConsumingOutputStream;
import io.codechicken.diffpatch.util.FileCollector;
import io.codechicken.diffpatch.util.IOValidationException;
import io.codechicken.diffpatch.util.Input;
import io.codechicken.diffpatch.util.LogLevel;
import io.codechicken.diffpatch.util.Operation;
import io.codechicken.diffpatch.util.Output;
import io.codechicken.diffpatch.util.PatchFile;
import io.codechicken.diffpatch.util.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.io.NullOutputStream;
import net.covers1624.quack.util.SneakyUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class DiffOperation
extends CliOperation<DiffSummary> {
    final boolean summary;
    final Input baseInput;
    final Input changedInput;
    final String aPrefix;
    final String bPrefix;
    final boolean autoHeader;
    final int context;
    final Output patchOutput;
    final String lineEnding;
    final String[] ignorePrefixes;

    private DiffOperation(PrintStream logger, LogLevel level, Consumer<PrintStream> helpCallback, boolean summary, Input baseInput, Input changedInput, String aPrefix, String bPrefix, boolean autoHeader, int context, Output patchOutput, String lineEnding, String[] ignorePrefixes) {
        super(logger, level, helpCallback);
        this.summary = summary;
        this.baseInput = baseInput;
        this.changedInput = changedInput;
        this.aPrefix = aPrefix;
        this.bPrefix = bPrefix;
        this.autoHeader = autoHeader;
        this.context = context;
        this.patchOutput = patchOutput;
        this.lineEnding = lineEnding;
        this.ignorePrefixes = ignorePrefixes;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public CliOperation.Result<DiffSummary> operate() throws IOException {
        Object object;
        try {
            this.baseInput.validate("base input");
            this.changedInput.validate("changed input");
            this.patchOutput.validate("patch output");
        }
        catch (IOValidationException ex) {
            this.log(LogLevel.ERROR, ex.getMessage(), new Object[0]);
            this.printHelp();
            return new CliOperation.Result<DiffSummary>(-1);
        }
        FileCollector patches = new FileCollector();
        DiffSummary summary = new DiffSummary();
        if (this.baseInput instanceof Input.SingleInput && this.changedInput instanceof Input.SingleInput) {
            boolean bl;
            Input.SingleInput base = (Input.SingleInput)this.baseInput;
            Input.SingleInput changed = (Input.SingleInput)this.changedInput;
            if (!(this.patchOutput instanceof Output.SingleOutput)) {
                this.log(LogLevel.ERROR, "Can't specify output directory or archive when diffing single files.", new Object[0]);
                this.printHelp();
                return new CliOperation.Result<DiffSummary>(-1);
            }
            Output.SingleOutput output = (Output.SingleOutput)this.patchOutput;
            List<String> lines = this.doDiff(summary, base.name(), changed.name(), base.readLines(), changed.readLines(), this.context, this.autoHeader);
            boolean bl2 = false;
            if (!lines.isEmpty()) {
                bl = true;
                try (PrintWriter out = new PrintWriter(output.open());){
                    out.print(String.join((CharSequence)this.lineEnding, lines));
                    out.print(this.lineEnding);
                }
            }
            if (this.summary) {
                summary.print(this.logger, true);
            }
            return new CliOperation.Result<DiffSummary>(bl ? 1 : 0, summary);
        }
        if (!(this.baseInput instanceof Input.MultiInput)) {
            this.log(LogLevel.ERROR, "Can't diff between single files and folders/archives.", new Object[0]);
            this.printHelp();
            return new CliOperation.Result<DiffSummary>(-1);
        }
        if (!(this.changedInput instanceof Input.MultiInput)) {
            this.log(LogLevel.ERROR, "Can't diff between folders/archives and single files.", new Object[0]);
            this.printHelp();
            return new CliOperation.Result<DiffSummary>(-1);
        }
        try (Input.MultiInput base = (Input.MultiInput)this.baseInput;){
            Input.MultiInput changed = (Input.MultiInput)this.changedInput;
            object = null;
            try {
                base.open("");
                changed.open("");
                Set<String> set = Utils.filterPrefixed(base.index(), this.ignorePrefixes);
                Set<String> bIndex = Utils.filterPrefixed(changed.index(), this.ignorePrefixes);
                this.doDiff(patches, summary, set, bIndex, base, changed, this.context, this.autoHeader);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (changed != null) {
                    if (object != null) {
                        try {
                            changed.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        changed.close();
                    }
                }
            }
        }
        boolean changes = false;
        if (!patches.isEmpty()) {
            changes = true;
            if (this.patchOutput instanceof Output.SingleOutput) {
                Output.SingleOutput singleOut = (Output.SingleOutput)this.patchOutput;
                PrintWriter out = new PrintWriter(singleOut.open());
                object = null;
                try {
                    for (FileCollector.CollectedEntry entry : patches.values()) {
                        List<String> lines = ((FileCollector.LinesCollectedEntry)entry).lines;
                        lines.forEach(line -> {
                            out.print((String)line);
                            out.print(this.lineEnding);
                        });
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (out != null) {
                        if (object != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            try (Output.MultiOutput output = (Output.MultiOutput)this.patchOutput;){
                output.open(true);
                for (Map.Entry entry : patches.get().entrySet()) {
                    output.write((String)entry.getKey(), ((FileCollector.CollectedEntry)entry.getValue()).toBytes(this.lineEnding, true));
                }
            }
        }
        if (this.summary) {
            summary.print(this.logger, false);
        }
        return new CliOperation.Result<DiffSummary>(changes ? 1 : 0, summary);
    }

    private void doDiff(FileCollector patches, DiffSummary summary, Set<String> aEntries, Set<String> bEntries, Input.MultiInput aInput, Input.MultiInput bInput, int context, boolean autoHeader) {
        String aName;
        List<String> patchLines;
        List<String> bLines;
        List<String> aLines;
        ArrayList added = FastStream.of(bEntries).filter(e -> !aEntries.contains(e)).sorted().toList();
        ArrayList common = FastStream.of(aEntries).filter(bEntries::contains).sorted().toList();
        ArrayList removed = FastStream.of(aEntries).filter(e -> !bEntries.contains(e)).sorted().toList();
        String aPrefix = StringUtils.appendIfMissing((String)(StringUtils.isEmpty((CharSequence)this.aPrefix) ? "a" : this.aPrefix), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        String bPrefix = StringUtils.appendIfMissing((String)(StringUtils.isEmpty((CharSequence)this.bPrefix) ? "b" : this.bPrefix), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        for (String file : added) {
            try {
                String bName = bPrefix + StringUtils.removeStart((String)file, (String)"/");
                aLines = Collections.emptyList();
                bLines = bInput.readLines(file);
                patchLines = this.doDiff(summary, null, bName, aLines, bLines, context, autoHeader);
                if (!patchLines.isEmpty()) {
                    ++summary.addedFiles;
                    patches.consume(file + ".patch", patchLines);
                    continue;
                }
                ++summary.unchangedFiles;
            }
            catch (IOException e2) {
                this.log(LogLevel.ERROR, "Failed to read file: %s", file);
            }
        }
        for (String file : common) {
            try {
                aName = aPrefix + StringUtils.removeStart((String)file, (String)"/");
                String bName = bPrefix + StringUtils.removeStart((String)file, (String)"/");
                List<String> aLines2 = aInput.readLines(file);
                List<String> bLines2 = bInput.readLines(file);
                List<String> patchLines2 = this.doDiff(summary, aName, bName, aLines2, bLines2, context, autoHeader);
                if (!patchLines2.isEmpty()) {
                    ++summary.changedFiles;
                    patches.consume(file + ".patch", patchLines2);
                    continue;
                }
                ++summary.unchangedFiles;
            }
            catch (IOException e3) {
                this.log(LogLevel.ERROR, "Failed to read file: %s", file);
            }
        }
        for (String file : removed) {
            try {
                aName = aPrefix + StringUtils.removeStart((String)file, (String)"/");
                aLines = aInput.readLines(file);
                bLines = Collections.emptyList();
                patchLines = this.doDiff(summary, aName, null, aLines, bLines, context, autoHeader);
                if (!patchLines.isEmpty()) {
                    ++summary.removedFiles;
                    patches.consume(file + ".patch", patchLines);
                    continue;
                }
                ++summary.unchangedFiles;
            }
            catch (IOException e4) {
                this.log(LogLevel.ERROR, "Failed to read file: %s", file);
            }
        }
    }

    private List<String> doDiff(DiffSummary summary, @Nullable String aName, @Nullable String bName, List<String> aLines, List<String> bLines, int context, boolean autoHeader) {
        PatienceDiffer differ = new PatienceDiffer();
        PatchFile patchFile = new PatchFile();
        patchFile.basePath = aName != null ? aName : "/dev/null";
        String string = patchFile.patchedPath = bName != null ? bName : "/dev/null";
        patchFile.patches = aLines.isEmpty() ? Differ.makeFileAdded(bLines) : (bLines.isEmpty() ? Differ.makeFileRemoved(aLines) : differ.makePatches(aLines, bLines, context, true));
        if (patchFile.patches.isEmpty()) {
            this.log(LogLevel.DEBUG, "%s -> %s\n No changes.", aName, bName);
            return Collections.emptyList();
        }
        long added = FastStream.of(patchFile.patches).flatMap(e -> e.diffs).filter(e -> e.op == Operation.INSERT).count();
        long removed = FastStream.of(patchFile.patches).flatMap(e -> e.diffs).filter(e -> e.op == Operation.DELETE).count();
        if (this.summary) {
            summary.addedLines += added;
            summary.removedLines += removed;
        }
        this.log(this.summary ? LogLevel.INFO : LogLevel.DEBUG, "%s -> %s\n %d Added.\n %d Removed.", aName, bName, added, removed);
        return patchFile.toLines(autoHeader);
    }

    public static class Builder {
        private static final PrintStream NULL_STREAM = new PrintStream((OutputStream)NullOutputStream.INSTANCE);
        private PrintStream logger = NULL_STREAM;
        private Consumer<PrintStream> helpCallback = SneakyUtils.nullCons();
        private LogLevel level = LogLevel.WARN;
        private boolean summary;
        @Nullable
        private Input baseInput;
        @Nullable
        private Input changedInput;
        private boolean autoHeader;
        private int context = 3;
        @Nullable
        private Output patchesOutput;
        private String aPrefix = "a/";
        private String bPrefix = "b/";
        private String lineEnding = System.lineSeparator();
        private final List<String> ignorePrefixes = new LinkedList<String>();

        private Builder() {
        }

        public Builder logTo(Consumer<String> func) {
            return this.logTo(new ConsumingOutputStream(func));
        }

        public Builder logTo(PrintStream logger) {
            this.logger = Objects.requireNonNull(logger);
            return this;
        }

        public Builder logTo(OutputStream logger) {
            return this.logTo(new PrintStream(logger));
        }

        public Builder helpCallback(Consumer<PrintStream> helpCallback) {
            this.helpCallback = Objects.requireNonNull(helpCallback);
            return this;
        }

        public Builder level(LogLevel level) {
            this.level = level;
            return this;
        }

        public Builder summary(boolean summary) {
            this.summary = summary;
            return this;
        }

        public Builder baseInput(Input baseInput) {
            this.baseInput = Objects.requireNonNull(baseInput);
            return this;
        }

        public Builder changedInput(Input changedInput) {
            this.changedInput = Objects.requireNonNull(changedInput);
            return this;
        }

        public Builder aPrefix(String aPrefix) {
            this.aPrefix = aPrefix;
            return this;
        }

        public Builder bPrefix(String bPrefix) {
            this.bPrefix = bPrefix;
            return this;
        }

        public Builder autoHeader(boolean autoHeader) {
            this.autoHeader = autoHeader;
            return this;
        }

        public Builder context(int context) {
            this.context = context;
            return this;
        }

        public Builder patchesOutput(Output patchesOutput) {
            this.patchesOutput = Objects.requireNonNull(patchesOutput);
            return this;
        }

        public Builder lineEnding(String lineEnding) {
            this.lineEnding = lineEnding;
            return this;
        }

        public Builder ignorePrefix(String prefix) {
            this.ignorePrefixes.add(prefix);
            return this;
        }

        public DiffOperation build() {
            if (this.baseInput == null) {
                throw new IllegalStateException("baseInput is required.");
            }
            if (this.changedInput == null) {
                throw new IllegalStateException("changedInput is required.");
            }
            if (this.patchesOutput == null) {
                throw new IllegalStateException("patchesOutput is required.");
            }
            return new DiffOperation(this.logger, this.level, this.helpCallback, this.summary, this.baseInput, this.changedInput, this.aPrefix, this.bPrefix, this.autoHeader, this.context, this.patchesOutput, this.lineEnding, this.ignorePrefixes.toArray(new String[0]));
        }
    }

    public static class DiffSummary {
        public int unchangedFiles;
        public int addedFiles;
        public int changedFiles;
        public int removedFiles;
        public long addedLines;
        public long removedLines;

        public void print(PrintStream logger, boolean slim) {
            logger.println("Diff Summary:");
            if (!slim) {
                logger.println(" UnChanged files: " + this.unchangedFiles);
                logger.println(" Added files:     " + this.addedFiles);
                logger.println(" Changed files:   " + this.changedFiles);
                logger.println(" Removed files:   " + this.removedFiles);
            }
            logger.println(" Added lines:     " + this.addedLines);
            logger.println(" Removed lines:   " + this.removedLines);
        }
    }
}

