/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector.data;

import de.oceanlabs.mcp.mcinjector.MCInjector;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum Exceptions {
    INSTANCE;

    private Map<String, String[]> exceptions = new HashMap<String, String[]>();

    public boolean load(Path file) {
        this.exceptions.clear();
        try {
            MCInjector.LOG.fine("Loading Exceptions from: " + file);
            Files.readAllLines(file).forEach(line -> {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
                    return;
                }
                int idx = line.indexOf(32, line.indexOf(32) + 1);
                if (idx == -1) {
                    MCInjector.LOG.warning("    Illegal Access Config Line: " + line);
                    return;
                }
                String key = line.substring(0, idx);
                CharSequence[] excs = line.substring(idx + 1).split(" ");
                MCInjector.LOG.fine("    Exceptions loaded " + key + ": (" + String.join((CharSequence)", ", excs) + ")");
                this.exceptions.put(key, (String[])excs);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            MCInjector.LOG.warning("Could not load Exception list: " + e.toString());
            return false;
        }
        return true;
    }

    public boolean dump(Path file) {
        try {
            List ret = this.exceptions.entrySet().stream().sorted((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey())).map(e -> (String)e.getKey() + " " + String.join((CharSequence)" ", (CharSequence[])e.getValue())).collect(Collectors.toList());
            Files.write(file, String.join((CharSequence)"\n", ret).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e3) {
            e3.printStackTrace();
            MCInjector.LOG.warning("Could not dump Exceptions list: " + e3.toString());
            return false;
        }
        return true;
    }

    public String[] getExceptions(String cls, String name, String desc) {
        String[] ret = this.exceptions.get(cls + "/" + name + " " + desc);
        return ret == null ? new String[]{} : ret;
    }

    public void setExceptions(String cls, String name, String desc, String[] excs) {
        this.exceptions.put(cls + "/" + name + " " + desc, excs);
    }
}

