/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector.data;

import de.oceanlabs.mcp.mcinjector.MCInjector;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum Access {
    INSTANCE;

    private Map<String, Level> changes = new HashMap<String, Level>();

    public boolean load(Path file) {
        this.changes.clear();
        try {
            MCInjector.LOG.fine("Loading Access Changes from: " + file);
            Files.readAllLines(file).forEach(line -> {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
                    return;
                }
                int idx = line.indexOf(32);
                Level level = Level.valueOf(line.substring(0, idx));
                String key = line.substring(idx + 1);
                MCInjector.LOG.fine("    Access loaded " + (Object)((Object)level) + " " + key);
                this.changes.put(key, level);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            MCInjector.LOG.warning("Could not load Access list: " + e.toString());
            return false;
        }
        return true;
    }

    public boolean dump(Path file) {
        try {
            List ret = this.changes.entrySet().stream().sorted((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey())).map(e -> e.getValue() + " " + (String)e.getKey()).collect(Collectors.toList());
            Files.write(file, String.join((CharSequence)"\n", ret).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e3) {
            e3.printStackTrace();
            MCInjector.LOG.warning("Could not dump Access list: " + e3.toString());
            return false;
        }
        return true;
    }

    public Level getLevel(String className) {
        return this.changes.get(className);
    }

    public Level getLevel(String cls, String name) {
        return this.changes.get(cls + " " + name);
    }

    public Level getLevel(String cls, String name, String desc) {
        return this.changes.get(cls + " " + name + " " + desc);
    }

    public static enum Level {
        PRIVATE,
        DEFAULT,
        PROTECTED,
        PUBLIC;


        public static Level getFromBytecode(int acc) {
            if ((acc & 2) == 2) {
                return PRIVATE;
            }
            if ((acc & 4) == 4) {
                return PROTECTED;
            }
            if ((acc & 1) == 1) {
                return PUBLIC;
            }
            return DEFAULT;
        }

        public int setAccess(int acc) {
            acc &= 0xFFFFFFF8;
            acc |= this == PRIVATE ? 2 : 0;
            acc |= this == PROTECTED ? 4 : 0;
            return acc |= this == PUBLIC ? 1 : 0;
        }
    }
}

