/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector.adaptors;

import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ParameterAnnotationFixer
extends ClassVisitor {
    private static final Logger LOGGER = Logger.getLogger("MCInjector");

    public ParameterAnnotationFixer(ClassVisitor cn, MCInjectorImpl mci) {
        super(393216, cn);
        try {
            MethodNode.class.getField("visibleAnnotableParameterCount");
            MethodNode.class.getField("invisibleAnnotableParameterCount");
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("AnnotableParameterCount fields are not present -- wrong ASM version?", ex);
        }
    }

    public void visitEnd() {
        super.visitEnd();
        ClassNode cls = MCInjectorImpl.getClassNode(this.cv);
        Type[] syntheticParams = this.getExpectedSyntheticParams(cls);
        if (syntheticParams != null) {
            for (MethodNode mn : cls.methods) {
                if (!mn.name.equals("<init>")) continue;
                this.processConstructor(cls, mn, syntheticParams);
            }
        }
    }

    private Type[] getExpectedSyntheticParams(ClassNode cls) {
        if ((cls.access & 0x4000) != 0) {
            LOGGER.fine("  Considering " + cls.name + " for extra parameter annotations as it is an enum");
            return new Type[]{Type.getObjectType((String)"java/lang/String"), Type.INT_TYPE};
        }
        InnerClassNode info = null;
        for (InnerClassNode node : cls.innerClasses) {
            if (!node.name.equals(cls.name)) continue;
            info = node;
            break;
        }
        if (info == null) {
            LOGGER.fine("  Not considering " + cls.name + " for extra parameter annotations as it is not an inner class");
            return null;
        }
        if ((info.access & 0x208) != 0) {
            LOGGER.fine("  Not considering " + cls.name + " for extra parameter annotations as is an interface or static");
            return null;
        }
        if (info.innerName == null) {
            LOGGER.fine("  Not considering " + cls.name + " for extra parameter annotations as it is annonymous");
            return null;
        }
        LOGGER.fine("  Considering " + cls.name + " for extra parameter annotations as it is an inner class of " + info.outerName);
        return new Type[]{Type.getObjectType((String)info.outerName)};
    }

    private void processConstructor(ClassNode cls, MethodNode mn, Type[] syntheticParams) {
        String methodInfo = mn.name + mn.desc + " in " + cls.name;
        Type[] params = Type.getArgumentTypes((String)mn.desc);
        if (this.beginsWith(params, syntheticParams)) {
            mn.visibleParameterAnnotations = this.process(methodInfo, "RuntimeVisibleParameterAnnotations", params.length, syntheticParams.length, mn.visibleParameterAnnotations);
            mn.invisibleParameterAnnotations = this.process(methodInfo, "RuntimeInvisibleParameterAnnotations", params.length, syntheticParams.length, mn.invisibleParameterAnnotations);
            if (mn.visibleParameterAnnotations != null) {
                mn.visibleAnnotableParameterCount = mn.visibleParameterAnnotations.length;
            }
            if (mn.invisibleParameterAnnotations != null) {
                mn.invisibleAnnotableParameterCount = mn.invisibleParameterAnnotations.length;
            }
        } else {
            LOGGER.warning("Unexpected lack of synthetic args to the constructor: expected " + Arrays.toString(syntheticParams) + " at the start of " + methodInfo);
        }
    }

    private boolean beginsWith(Type[] values, Type[] prefix) {
        if (values.length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (values[i].equals((Object)prefix[i])) continue;
            return false;
        }
        return true;
    }

    private List<AnnotationNode>[] process(String methodInfo, String attributeName, int numParams, int numSynthetic, List<AnnotationNode>[] annotations) {
        if (annotations == null) {
            LOGGER.finer("    " + methodInfo + " does not have a " + attributeName + " attribute");
            return null;
        }
        int numAnnotations = annotations.length;
        if (numParams == numAnnotations) {
            LOGGER.info("Found extra " + attributeName + " entries in " + methodInfo + ": removing " + numSynthetic);
            return Arrays.copyOfRange(annotations, numSynthetic, numAnnotations);
        }
        if (numParams == numAnnotations - numSynthetic) {
            LOGGER.info("Number of " + attributeName + " entries in " + methodInfo + " is already as we want");
            return annotations;
        }
        LOGGER.warning("Unexpected number of " + attributeName + " entries in " + methodInfo + ": " + numAnnotations);
        return annotations;
    }
}

