/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector.adaptors;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ClassInitAdder
extends ClassVisitor {
    private static final Logger log = Logger.getLogger("MCInjector");
    private String className;
    private String superName;
    private boolean hasInit = false;
    private Map<String, String> fields = new LinkedHashMap<String, String>();

    public ClassInitAdder(ClassVisitor cv) {
        super(393216, cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.superName = superName;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 0x10) == 16 && (access & 8) == 0) {
            this.fields.put(name, desc);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<init>".equals(name)) {
            this.hasInit = true;
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public void visitEnd() {
        if (!this.hasInit && !this.fields.isEmpty()) {
            log.fine("  Adding synthetic <init>");
            MethodVisitor mv = this.visitMethod(2, "<init>", "()V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, this.superName, "<init>", "()V", false);
            for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                mv.visitVarInsn(25, 0);
                switch (Type.getType((String)entry.getValue()).getSort()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        mv.visitInsn(3);
                        break;
                    }
                    case 6: {
                        mv.visitInsn(11);
                        break;
                    }
                    case 7: {
                        mv.visitInsn(9);
                        break;
                    }
                    case 8: {
                        mv.visitInsn(14);
                        break;
                    }
                    default: {
                        mv.visitInsn(1);
                    }
                }
                mv.visitFieldInsn(181, this.className, entry.getKey(), entry.getValue());
                log.fine("    Field: " + entry.getKey());
            }
            mv.visitTypeInsn(187, "java/lang/RuntimeException");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)"Synthetic constructor added by MCP, do not call");
            mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V", false);
            mv.visitInsn(191);
        }
        super.visitEnd();
    }
}

