/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector;

import de.oceanlabs.mcp.mcinjector.MCInjector;
import de.oceanlabs.mcp.mcinjector.adaptors.AccessFixer;
import de.oceanlabs.mcp.mcinjector.adaptors.ApplyMap;
import de.oceanlabs.mcp.mcinjector.adaptors.ClassInitAdder;
import de.oceanlabs.mcp.mcinjector.adaptors.InnerClassInitAdder;
import de.oceanlabs.mcp.mcinjector.adaptors.ParameterAnnotationFixer;
import de.oceanlabs.mcp.mcinjector.data.Access;
import de.oceanlabs.mcp.mcinjector.data.Constructors;
import de.oceanlabs.mcp.mcinjector.data.Exceptions;
import de.oceanlabs.mcp.mcinjector.lvt.LVTFernflower;
import de.oceanlabs.mcp.mcinjector.lvt.LVTLvt;
import de.oceanlabs.mcp.mcinjector.lvt.LVTNaming;
import de.oceanlabs.mcp.mcinjector.lvt.LVTStrip;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MCInjectorImpl {
    public LVTNaming naming = LVTNaming.STRIP;
    private Map<String, List<String>> abstractParameters = new HashMap<String, List<String>>();
    private static Field field_mv;
    private static Field field_cv;

    static void process(Path in, Path out, Path accIn, Path accOut, Path ctrIn, Path ctrOut, Path excIn, Path excOut, LVTNaming naming) throws IOException {
        if (accIn != null) {
            Access.INSTANCE.load(accIn);
        }
        if (ctrIn != null) {
            Constructors.INSTANCE.load(ctrIn);
        }
        if (excIn != null) {
            Exceptions.INSTANCE.load(excIn);
        }
        MCInjector.LOG.info("Processing: " + in);
        MCInjector.LOG.info("  Output: " + out);
        MCInjectorImpl mci = new MCInjectorImpl();
        mci.naming = naming;
        mci.processJar(in, out);
        if (accOut != null) {
            Access.INSTANCE.dump(accOut);
        }
        if (ctrOut != null) {
            Constructors.INSTANCE.dump(ctrOut);
        }
        if (excOut != null) {
            Exceptions.INSTANCE.dump(excOut);
        }
        MCInjector.LOG.info("Processed " + in);
    }

    private MCInjectorImpl() {
    }

    private void processJar(Path inFile, Path outFile) throws IOException {
        HashSet<String> entries = new HashSet<String>();
        try (ZipInputStream inJar = new ZipInputStream(Files.newInputStream(inFile, new OpenOption[0]));
             ZipOutputStream outJar = new ZipOutputStream(outFile == null ? new ByteArrayOutputStream() : Files.newOutputStream(outFile, new OpenOption[0]));){
            ZipEntry entry = inJar.getNextEntry();
            while (entry != null) {
                String entryName = entry.getName();
                if (entry.isDirectory()) {
                    outJar.putNextEntry(new JarEntry(entryName));
                    outJar.closeEntry();
                } else {
                    boolean mojang;
                    int len;
                    byte[] data = new byte[4096];
                    ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
                    do {
                        if ((len = inJar.read(data)) <= 0) continue;
                        entryBuffer.write(data, 0, len);
                    } while (len != -1);
                    byte[] entryData = entryBuffer.toByteArray();
                    boolean bl = mojang = entryName.startsWith("net/minecraft/") || entryName.startsWith("com/mojang/");
                    if (entryName.endsWith(".class") && mojang) {
                        MCInjector.LOG.log(Level.INFO, "Processing " + entryName);
                        entryData = this.processClass(entryData, outFile == null);
                        MCInjector.LOG.log(Level.INFO, "Processed " + entryBuffer.size() + " -> " + entryData.length);
                    } else {
                        MCInjector.LOG.log(Level.INFO, "Copying " + entryName);
                    }
                    ZipEntry newEntry = new ZipEntry(entryName);
                    newEntry.setTime(0L);
                    outJar.putNextEntry(newEntry);
                    outJar.write(entryData);
                    outJar.closeEntry();
                    entries.add(entryName);
                }
                entry = inJar.getNextEntry();
            }
            if (!this.abstractParameters.isEmpty() && !entries.contains("fernflower_abstract_parameter_names.txt")) {
                ZipEntry newEntry = new ZipEntry("fernflower_abstract_parameter_names.txt");
                newEntry.setTime(0L);
                outJar.putNextEntry(newEntry);
                for (String key : this.abstractParameters.keySet().stream().sorted().collect(Collectors.toList())) {
                    outJar.write(key.getBytes(StandardCharsets.UTF_8));
                    outJar.write(32);
                    outJar.write(this.abstractParameters.get(key).stream().collect(Collectors.joining(" ")).getBytes(StandardCharsets.UTF_8));
                    outJar.write(10);
                }
                outJar.closeEntry();
            }
        }
    }

    public byte[] processClass(byte[] cls, boolean readOnly) {
        ClassNode cn;
        ClassReader cr = new ClassReader(cls);
        Object ca = cn = new ClassNode();
        if (!readOnly) {
            ca = new ApplyMap(this, (ClassVisitor)ca);
            switch (this.naming) {
                case STRIP: {
                    ca = new LVTStrip((ClassVisitor)ca);
                    break;
                }
                case FERNFLOWER: {
                    ca = new LVTFernflower((ClassVisitor)ca);
                    break;
                }
                case LVT: {
                    ca = new LVTLvt((ClassVisitor)ca);
                }
            }
            ca = new AccessFixer((ClassVisitor)ca);
            ca = new ParameterAnnotationFixer((ClassVisitor)ca, this);
            ca = new InnerClassInitAdder((ClassVisitor)ca);
            ca = new ClassInitAdder((ClassVisitor)ca);
        }
        ca = new ClassVisitor(393216, (ClassVisitor)ca){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                MCInjector.LOG.log(Level.FINE, "Class: " + name + " Extends: " + superName);
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MCInjector.LOG.log(Level.FINE, "  Name: " + name + " Desc: " + desc + " Sig: " + signature);
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        cr.accept((ClassVisitor)ca, 0);
        ClassWriter writer = new ClassWriter(1);
        cn.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static MethodNode getMethodNode(MethodVisitor mv) {
        try {
            if (field_mv == null) {
                field_mv = MethodVisitor.class.getDeclaredField("mv");
                field_mv.setAccessible(true);
            }
            MethodVisitor tmp = mv;
            while (!(tmp instanceof MethodNode) && tmp != null) {
                tmp = (MethodVisitor)field_mv.get(tmp);
            }
            return (MethodNode)tmp;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static ClassNode getClassNode(ClassVisitor cv) {
        try {
            if (field_cv == null) {
                field_cv = ClassVisitor.class.getDeclaredField("cv");
                field_cv.setAccessible(true);
            }
            ClassVisitor tmp = cv;
            while (!(tmp instanceof ClassNode) && tmp != null) {
                tmp = (ClassVisitor)field_cv.get(tmp);
            }
            return (ClassNode)tmp;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void storeAbstractParameters(String className, String name, String desc, List<String> params) {
        this.abstractParameters.put(className + ' ' + name + ' ' + desc, params);
    }
}

