/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector;

import de.oceanlabs.mcp.mcinjector.LogFormatter;
import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import de.oceanlabs.mcp.mcinjector.lvt.LVTNaming;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;

public class MCInjector {
    public static final Logger LOG = Logger.getLogger("MCInjector");
    public static final String VERSION = "MCInjector v" + Optional.ofNullable(MCInjector.class.getPackage().getImplementationVersion()).orElse("Unknown") + " by Searge, LexManos, Fesh0r";
    private Path fileIn;
    private Path fileOut;
    private Path excIn;
    private Path excOut;
    private Path accIn;
    private Path accOut;
    private Path ctrIn;
    private Path ctrOut;
    private LVTNaming lvt;
    private static ValueConverter<Path> PATH_ARG = new ValueConverter<Path>(){

        public Path convert(String value) {
            return Paths.get(value, new String[0]);
        }

        public Class<Path> valueType() {
            return Path.class;
        }

        public String valuePattern() {
            return null;
        }
    };
    private static ValueConverter<Level> LEVEL_ARG = new ValueConverter<Level>(){

        public Level convert(String value) {
            return Level.parse(value.toUpperCase(Locale.ENGLISH));
        }

        public Class<Level> valueType() {
            return Level.class;
        }

        public String valuePattern() {
            return null;
        }
    };

    public MCInjector(Path fileIn, Path fileOut) {
        this.fileIn = fileIn;
        this.fileOut = fileOut;
    }

    public MCInjector log(Path log) {
        if (log == null) {
            return this;
        }
        try {
            FileHandler filehandler = new FileHandler(log.toString());
            filehandler.setFormatter(new LogFormatter());
            LOG.addHandler(filehandler);
        }
        catch (IOException e) {
            System.out.println("Failed to setup logger: " + e.toString());
            e.printStackTrace();
        }
        return this;
    }

    public MCInjector log() {
        return this.log(System.out);
    }

    public MCInjector log(final PrintStream stream) {
        LOG.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                stream.println(String.format(record.getMessage(), record.getParameters()));
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        return this;
    }

    public MCInjector exceptions(Path exc) {
        this.excIn = exc;
        return this;
    }

    public MCInjector exceptionsOut(Path out) {
        this.excOut = out;
        return this;
    }

    public MCInjector access(Path acc) {
        this.accIn = acc;
        return this;
    }

    public MCInjector accessOut(Path out) {
        this.accOut = out;
        return this;
    }

    public MCInjector constructors(Path ctrs) {
        this.ctrIn = ctrs;
        return this;
    }

    public MCInjector constructorsOut(Path out) {
        this.ctrOut = out;
        return this;
    }

    public MCInjector lvt(LVTNaming lvt) {
        this.lvt = lvt;
        return this;
    }

    public void process() throws IOException {
        MCInjectorImpl.process(this.fileIn, this.fileOut, this.accIn, this.accOut, this.ctrIn, this.ctrOut, this.excIn, this.excOut, this.lvt);
    }

    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        AbstractOptionSpec help = parser.accepts("help").forHelp();
        AbstractOptionSpec ver = parser.accepts("version").forHelp();
        ArgumentAcceptingOptionSpec in = parser.accepts("in").withRequiredArg().withValuesConvertedBy(PATH_ARG).required();
        ArgumentAcceptingOptionSpec out = parser.accepts("out").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec log = parser.accepts("log").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec exc = parser.accepts("exc").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec excOut = parser.accepts("excOut").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec acc = parser.accepts("acc").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec accOut = parser.accepts("accOut").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec ctr = parser.accepts("ctr").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec ctrOut = parser.accepts("ctrOut").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec logLvl = parser.accepts("level").withRequiredArg().withValuesConvertedBy(LEVEL_ARG).defaultsTo((Object)Level.INFO, (Object[])new Level[0]);
        ArgumentAcceptingOptionSpec lvt = parser.accepts("lvt").withRequiredArg().ofType(LVTNaming.class).defaultsTo((Object)LVTNaming.STRIP, (Object[])new LVTNaming[0]);
        try {
            OptionSet o = parser.parse(args);
            if (o.has((OptionSpec)help)) {
                System.out.println(VERSION);
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            if (o.has((OptionSpec)ver)) {
                System.out.println(VERSION);
                return;
            }
            LOG.setUseParentHandlers(false);
            LOG.setLevel((Level)o.valueOf((OptionSpec)logLvl));
            LOG.info(VERSION);
            LOG.info("Input:        " + o.valueOf((OptionSpec)in));
            LOG.info("Output:       " + o.valueOf((OptionSpec)out));
            LOG.info("Log:          " + o.valueOf((OptionSpec)log));
            LOG.info("Exceptions:   " + o.valueOf((OptionSpec)exc));
            LOG.info("              " + o.valueOf((OptionSpec)excOut));
            LOG.info("Access:       " + o.valueOf((OptionSpec)acc));
            LOG.info("              " + o.valueOf((OptionSpec)accOut));
            LOG.info("Constructors: " + o.valueOf((OptionSpec)ctr));
            LOG.info("              " + o.valueOf((OptionSpec)ctrOut));
            LOG.info("LVT:          " + o.valueOf((OptionSpec)lvt));
            try {
                new MCInjector((Path)o.valueOf((OptionSpec)in), (Path)o.valueOf((OptionSpec)out)).log().lvt((LVTNaming)((Object)o.valueOf((OptionSpec)lvt))).log((Path)o.valueOf((OptionSpec)log)).exceptions((Path)o.valueOf((OptionSpec)exc)).exceptionsOut((Path)o.valueOf((OptionSpec)excOut)).access((Path)o.valueOf((OptionSpec)acc)).accessOut((Path)o.valueOf((OptionSpec)accOut)).constructors((Path)o.valueOf((OptionSpec)ctr)).constructorsOut((Path)o.valueOf((OptionSpec)ctrOut)).process();
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e.getMessage());
                LOG.log(Level.SEVERE, "ERROR", e);
                e.printStackTrace();
                System.exit(1);
            }
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }
}

