/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish.nexus;

import com.vanniktech.maven.publish.nexus.CreateRepositoryInput;
import com.vanniktech.maven.publish.nexus.CreateRepositoryInputData;
import com.vanniktech.maven.publish.nexus.CreateRepositoryResponse;
import com.vanniktech.maven.publish.nexus.CreatedRepository;
import com.vanniktech.maven.publish.nexus.Nexus;
import com.vanniktech.maven.publish.nexus.NexusOkHttpInterceptor;
import com.vanniktech.maven.publish.nexus.NexusService;
import com.vanniktech.maven.publish.nexus.ProfileRepositoriesResponse;
import com.vanniktech.maven.publish.nexus.Repository;
import com.vanniktech.maven.publish.nexus.RepositoryActivity;
import com.vanniktech.maven.publish.nexus.RepositoryEvent;
import com.vanniktech.maven.publish.nexus.RepositoryEventProperty;
import com.vanniktech.maven.publish.nexus.StagingProfile;
import com.vanniktech.maven.publish.nexus.StagingProfilesResponse;
import com.vanniktech.maven.publish.nexus.TransitionRepositoryInput;
import com.vanniktech.maven.publish.nexus.TransitionRepositoryInputData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\u0018\u0000 (2\u00020\u0001:\u0001(B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0013\u001a\u00020\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003J\u0018\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u0015J\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0003J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\b\u0010!\u001a\u00020\u0017H\u0002J\u0010\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010#H\u0002J\u0010\u0010$\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010#H\u0002J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u000e\u0010&\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0003J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/vanniktech/maven/publish/nexus/Nexus;", "", "baseUrl", "", "username", "password", "userAgentName", "userAgentVersion", "okhttpTimeoutSeconds", "", "closeTimeoutSeconds", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JJ)V", "service", "Lcom/vanniktech/maven/publish/nexus/NexusService;", "kotlin.jvm.PlatformType", "getService", "()Lcom/vanniktech/maven/publish/nexus/NexusService;", "service$delegate", "Lkotlin/Lazy;", "closeCurrentStagingRepository", "closeStagingRepository", "", "stagingRepository", "Lcom/vanniktech/maven/publish/nexus/Repository;", "repositoryId", "createRepositoryForGroup", "group", "createStagingRepository", "profile", "Lcom/vanniktech/maven/publish/nexus/StagingProfile;", "dropCurrentStagingRepository", "dropStagingRepository", "findStagingProfile", "findStagingRepository", "getProfileRepositories", "", "getProfiles", "getStagingRepository", "releaseStagingRepository", "waitForClose", "Companion", "nexus"})
@SourceDebugExtension(value={"SMAP\nNexus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Nexus.kt\ncom/vanniktech/maven/publish/nexus/Nexus\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n766#2:289\n857#2,2:290\n766#2:293\n857#2,2:294\n766#2:296\n857#2,2:297\n766#2:299\n857#2,2:300\n1#3:292\n*S KotlinDebug\n*F\n+ 1 Nexus.kt\ncom/vanniktech/maven/publish/nexus/Nexus\n*L\n57#1:289\n57#1:290,2\n58#1:293\n58#1:294,2\n59#1:296\n59#1:297,2\n209#1:299\n209#1:300,2\n*E\n"})
public final class Nexus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String baseUrl;
    @NotNull
    private final String username;
    private final long closeTimeoutSeconds;
    @NotNull
    private final Lazy service$delegate;
    @NotNull
    private static final String PROGRESS_1 = "\u2839";
    @NotNull
    private static final String PROGRESS_2 = "\u2838";
    @NotNull
    private static final String PROGRESS_3 = "\u2834";
    @NotNull
    private static final String PROGRESS_4 = "\u2826";
    @NotNull
    private static final String PROGRESS_5 = "\u2807";
    @NotNull
    private static final String PROGRESS_6 = "\u280f";
    @NotNull
    private static final String PROGRESS_7 = "\u2819";
    private static final long CLOSE_WAIT_INTERVAL_MILLIS = 10000L;

    public Nexus(@NotNull String baseUrl, @NotNull String username, @NotNull String password, @NotNull String userAgentName, @NotNull String userAgentVersion, long okhttpTimeoutSeconds, long closeTimeoutSeconds) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)userAgentName, (String)"userAgentName");
        Intrinsics.checkNotNullParameter((Object)userAgentVersion, (String)"userAgentVersion");
        this.baseUrl = baseUrl;
        this.username = username;
        this.closeTimeoutSeconds = closeTimeoutSeconds;
        this.service$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NexusService>(this, password, userAgentName, userAgentVersion, okhttpTimeoutSeconds){
            final /* synthetic */ Nexus this$0;
            final /* synthetic */ String $password;
            final /* synthetic */ String $userAgentName;
            final /* synthetic */ String $userAgentVersion;
            final /* synthetic */ long $okhttpTimeoutSeconds;
            {
                this.this$0 = $receiver;
                this.$password = $password;
                this.$userAgentName = $userAgentName;
                this.$userAgentVersion = $userAgentVersion;
                this.$okhttpTimeoutSeconds = $okhttpTimeoutSeconds;
                super(0);
            }

            public final NexusService invoke() {
                OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new NexusOkHttpInterceptor(Nexus.access$getUsername$p(this.this$0), this.$password, this.$userAgentName, this.$userAgentVersion)).connectTimeout(this.$okhttpTimeoutSeconds, TimeUnit.SECONDS).readTimeout(this.$okhttpTimeoutSeconds, TimeUnit.SECONDS).writeTimeout(this.$okhttpTimeoutSeconds, TimeUnit.SECONDS).build();
                Retrofit retrofit = new Retrofit.Builder().addConverterFactory((Converter.Factory)MoshiConverterFactory.create()).client(okHttpClient).baseUrl(Nexus.access$getBaseUrl$p(this.this$0)).build();
                return (NexusService)retrofit.create(NexusService.class);
            }
        }));
    }

    private final NexusService getService() {
        Lazy lazy = this.service$delegate;
        return (NexusService)lazy.getValue();
    }

    private final List<StagingProfile> getProfiles() {
        Response stagingProfilesResponse = this.getService().getStagingProfiles().execute();
        if (!stagingProfilesResponse.isSuccessful()) {
            ResponseBody responseBody = stagingProfilesResponse.errorBody();
            throw new IOException("Cannot get stagingProfiles for account " + this.username + ": " + (responseBody != null ? responseBody.string() : null));
        }
        StagingProfilesResponse stagingProfilesResponse2 = (StagingProfilesResponse)stagingProfilesResponse.body();
        return stagingProfilesResponse2 != null ? stagingProfilesResponse2.getData() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final StagingProfile findStagingProfile(String group) {
        Collection collection;
        Collection collection2;
        StagingProfile it;
        Collection destination$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterTo$iv$iv;
        List allProfiles;
        List list = this.getProfiles();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if ((allProfiles = list).isEmpty()) {
            throw new IllegalArgumentException("No staging profiles found in account " + this.username + ". Make sure you called \"./gradlew publish\".");
        }
        if (allProfiles.size() == 1) {
            return (StagingProfile)allProfiles.get(0);
        }
        Iterable $this$filter$iv2 = allProfiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StagingProfile it2 = (StagingProfile)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)group, (Object)it2.getName())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Collection collection3 = (List)destination$iv$iv2;
        if (collection3.isEmpty()) {
            void $this$filterTo$iv$iv2;
            boolean bl = false;
            $this$filter$iv = allProfiles;
            boolean $i$f$filter2 = false;
            Iterable $i$f$filterTo2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (StagingProfile)element$iv$iv;
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)group, (String)it.getName(), (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection2 = (List)destination$iv$iv;
        } else {
            collection2 = collection3 = collection3;
        }
        if (collection3.isEmpty()) {
            boolean bl = false;
            $this$filter$iv = allProfiles;
            boolean $i$f$filter3 = false;
            Iterable $this$filterTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo4 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (StagingProfile)element$iv$iv;
                boolean bl3 = false;
                boolean bl4 = ((CharSequence)StringsKt.commonPrefixWith$default((CharSequence)group, (CharSequence)it.getName(), (boolean)false, (int)2, null)).length() > 0;
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = collection3;
        }
        List candidateProfiles = (List)collection;
        if (candidateProfiles.isEmpty()) {
            throw new IllegalArgumentException("No matching staging profile found in account " + this.username + ". It is expected that the account contains a staging profile that matches or is the start of " + group + ". Available profiles are: " + CollectionsKt.joinToString$default((Iterable)allProfiles, (CharSequence)", ", null, null, (int)0, null, (Function1)findStagingProfile.1.INSTANCE, (int)30, null));
        }
        if (candidateProfiles.size() > 1) {
            throw new IllegalArgumentException("More than 1 matching staging profile found in account " + this.username + ". Available profiles are: " + CollectionsKt.joinToString$default((Iterable)allProfiles, (CharSequence)", ", null, null, (int)0, null, (Function1)findStagingProfile.2.INSTANCE, (int)30, null));
        }
        return (StagingProfile)candidateProfiles.get(0);
    }

    private final String createStagingRepository(String group, StagingProfile profile) {
        System.out.println((Object)("Creating repository in profile: " + profile.getName()));
        Response response = this.getService().createRepository(profile.getId(), new CreateRepositoryInput(new CreateRepositoryInputData("Repository for " + group))).execute();
        if (!response.isSuccessful()) {
            ResponseBody responseBody = response.errorBody();
            throw new IOException("Cannot create repository: " + (responseBody != null ? responseBody.string() : null));
        }
        Object object = (CreateRepositoryResponse)response.body();
        if (object == null || (object = ((CreateRepositoryResponse)object).getData()) == null || (object = ((CreatedRepository)object).getStagedRepositoryId()) == null) {
            throw new IOException("Did not receive created repository");
        }
        Object id = object;
        System.out.println((Object)("Created staging repository " + (String)id));
        return id;
    }

    @NotNull
    public final String createRepositoryForGroup(@NotNull String group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        StagingProfile profile = this.findStagingProfile(group);
        return this.createStagingRepository(group, profile);
    }

    private final List<Repository> getProfileRepositories() {
        Response profileRepositoriesResponse = this.getService().getProfileRepositories().execute();
        if (!profileRepositoriesResponse.isSuccessful()) {
            ResponseBody responseBody = profileRepositoriesResponse.errorBody();
            throw new IOException("Cannot get profileRepositories for account " + this.username + ": " + (responseBody != null ? responseBody.string() : null));
        }
        ProfileRepositoriesResponse profileRepositoriesResponse2 = (ProfileRepositoriesResponse)profileRepositoriesResponse.body();
        return profileRepositoriesResponse2 != null ? profileRepositoriesResponse2.getData() : null;
    }

    private final Repository findStagingRepository() {
        List allRepositories;
        List list = this.getProfileRepositories();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if ((allRepositories = list).isEmpty()) {
            throw new IllegalArgumentException("No matching staging repository found in account " + this.username + ". You can can explicitly choose one by passing it as an option like this \"./gradlew closeAndReleaseRepository --repository=comexample-123\". Available repositories are: " + CollectionsKt.joinToString$default((Iterable)allRepositories, (CharSequence)", ", null, null, (int)0, null, (Function1)findStagingRepository.1.INSTANCE, (int)30, null));
        }
        if (allRepositories.size() > 1) {
            throw new IllegalArgumentException("More than 1 matching staging repository found in account " + this.username + ". You can can explicitly choose one by passing it as an option like this \"./gradlew closeAndReleaseRepository --repository comexample-123\". Available repositories are: " + CollectionsKt.joinToString$default((Iterable)allRepositories, (CharSequence)", ", null, null, (int)0, null, (Function1)findStagingRepository.2.INSTANCE, (int)30, null));
        }
        return (Repository)allRepositories.get(0);
    }

    private final Repository getStagingRepository(String repositoryId) {
        Response repositoryResponse = this.getService().getRepository(repositoryId).execute();
        if (!repositoryResponse.isSuccessful()) {
            ResponseBody responseBody = repositoryResponse.errorBody();
            throw new IOException("Cannot get repository with id " + repositoryId + " for account " + this.username + ": " + (responseBody != null ? responseBody.string() : null));
        }
        Repository repository = (Repository)repositoryResponse.body();
        if (repository == null) {
            throw new IOException("Could not get repository with id " + repositoryId + " for account " + this.username);
        }
        return repository;
    }

    private final void closeStagingRepository(Repository stagingRepository) {
        String repositoryId = stagingRepository.getRepositoryId();
        if (Intrinsics.areEqual((Object)stagingRepository.getType(), (Object)"closed")) {
            if (stagingRepository.getTransitioning()) {
                this.waitForClose(stagingRepository.getRepositoryId());
            } else {
                System.out.println((Object)("Repository " + repositoryId + " already closed"));
            }
            return;
        }
        if (!Intrinsics.areEqual((Object)stagingRepository.getType(), (Object)"open")) {
            throw new IllegalArgumentException("Repository " + repositoryId + " is of type '" + stagingRepository.getType() + "' and not 'open'");
        }
        System.out.println((Object)("Closing repository: " + repositoryId));
        Response response = this.getService().closeRepository(new TransitionRepositoryInput(new TransitionRepositoryInputData(CollectionsKt.listOf((Object)repositoryId), null, 2, null))).execute();
        if (!response.isSuccessful()) {
            ResponseBody responseBody = response.errorBody();
            throw new IOException("Cannot close repository: " + (responseBody != null ? responseBody.string() : null));
        }
        this.waitForClose(repositoryId);
        System.out.println((Object)("Repository " + repositoryId + " closed"));
    }

    /*
     * Unable to fully structure code
     */
    private final void waitForClose(String repositoryId) {
        block13: {
            startMillis = System.currentTimeMillis();
            var5_3 = new String[]{"\u2839", "\u2838", "\u2834", "\u2826", "\u2807", "\u280f", "\u2819"};
            waitingChars = CollectionsKt.listOf((Object[])var5_3);
            i = 0;
            do {
                if (System.currentTimeMillis() - startMillis > TimeUnit.SECONDS.toMillis(this.closeTimeoutSeconds)) {
                    throw new IOException("Timeout waiting for repository close");
                }
                System.out.print((Object)("\r" + waitingChars.get(i++ % waitingChars.size()) + " waiting for close..."));
                System.out.flush();
                Thread.sleep(10000L);
                try {
                    var7_7 = this.getStagingRepository(repositoryId);
                }
                catch (IOException e) {
                    System.err.println("Exception trying to get repository status: " + e.getMessage());
                    var7_7 = null;
                }
                catch (TimeoutException e) {
                    System.err.println("Exception trying to get repository status: " + e.getMessage());
                    var7_7 = null;
                }
                v0 = repository = var7_7;
                if (Intrinsics.areEqual((Object)(v0 != null ? v0.getType() : null), (Object)"closed") && !repository.getTransitioning()) break block13;
                v1 = repository;
            } while (!Intrinsics.areEqual((Object)(v1 != null ? v1.getType() : null), (Object)"open") || repository.getTransitioning() || repository.getNotifications() <= 0);
            try {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                response = this.getService().getRepositoryActivity(repositoryId).execute();
                                if (!response.isSuccessful()) break block16;
                                var9_11 = (List)response.body();
                                if (var9_11 == null) ** GOTO lbl-1000
                                var12_13 = var9_11;
                                var13_14 = var12_13.iterator();
                                while (var13_14.hasNext()) {
                                    var14_15 = var13_14.next();
                                    it = (RepositoryActivity)var14_15;
                                    $i$a$-find-Nexus$waitForClose$properties$1 = false;
                                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"close")) continue;
                                    v2 = var14_15;
                                    break block14;
                                }
                                v2 = null;
                            }
                            var10_21 = v2;
                            if (var10_21 == null || (var11_22 = var10_21.getEvents()) == null) ** GOTO lbl-1000
                            var14_15 = var11_22;
                            it = var14_15.iterator();
                            while (it.hasNext()) {
                                $i$a$-find-Nexus$waitForClose$properties$1 = it.next();
                                it = (RepositoryEvent)$i$a$-find-Nexus$waitForClose$properties$1;
                                $i$a$-find-Nexus$waitForClose$properties$2 = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"ruleFailed")) continue;
                                v3 = $i$a$-find-Nexus$waitForClose$properties$1;
                                break block15;
                            }
                            v3 = null;
                        }
                        var12_13 = v3;
                        if (var12_13 != null && (var13_14 = var12_13.getProperties()) != null) {
                            $this$filter$iv = (Iterable)var13_14;
                            $i$f$filter = false;
                            $i$a$-find-Nexus$waitForClose$properties$1 = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                it = (RepositoryEventProperty)element$iv$iv;
                                $i$a$-filter-Nexus$waitForClose$properties$3 = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"failureMessage")) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            v4 = (List)destination$iv$iv;
                        } else lbl-1000:
                        // 3 sources

                        {
                            v4 = null;
                        }
                        break block17;
                    }
                    v4 = CollectionsKt.emptyList();
                }
                response = v4;
            }
            catch (IOException _) {
                response = CollectionsKt.emptyList();
            }
            properties = response;
            response = properties;
            if (response == null || response.isEmpty() != false) {
                url = String.valueOf(HttpUrl.Companion.get(this.baseUrl).newBuilder("/#stagingRepositories"));
                throw new IOException("Closing the repository failed. " + repository.getNotifications() + " messages are available on " + url);
            }
            message = CollectionsKt.joinToString$default((Iterable)properties, (CharSequence)"\n", null, null, (int)0, null, (Function1)waitForClose.message.1.INSTANCE, (int)30, null);
            throw new IOException("Closing the repository failed with the following errors:\n" + message);
        }
    }

    @NotNull
    public final String closeCurrentStagingRepository() {
        Repository stagingRepository = this.findStagingRepository();
        this.closeStagingRepository(stagingRepository);
        return stagingRepository.getRepositoryId();
    }

    public final void closeStagingRepository(@NotNull String repositoryId) {
        Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
        Repository stagingRepository = this.getStagingRepository(repositoryId);
        this.closeStagingRepository(stagingRepository);
    }

    public final void releaseStagingRepository(@NotNull String repositoryId) {
        Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
        System.out.println((Object)("Releasing repository: " + repositoryId));
        Response response = this.getService().releaseRepository(new TransitionRepositoryInput(new TransitionRepositoryInputData(CollectionsKt.listOf((Object)repositoryId), true))).execute();
        if (!response.isSuccessful()) {
            ResponseBody responseBody = response.errorBody();
            throw new IOException("Cannot release repository: " + (responseBody != null ? responseBody.string() : null));
        }
        System.out.println((Object)("Repository " + repositoryId + " released"));
    }

    public final void dropStagingRepository(@NotNull String repositoryId) {
        Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
        Response response = this.getService().dropRepository(new TransitionRepositoryInput(new TransitionRepositoryInputData(CollectionsKt.listOf((Object)repositoryId), null, 2, null))).execute();
        if (!response.isSuccessful()) {
            ResponseBody responseBody = response.errorBody();
            throw new IOException("Cannot drop repository: " + (responseBody != null ? responseBody.string() : null));
        }
    }

    public final void dropCurrentStagingRepository() {
        Repository stagingRepository = this.findStagingRepository();
        this.dropStagingRepository(stagingRepository.getRepositoryId());
    }

    public static final /* synthetic */ String access$getUsername$p(Nexus $this) {
        return $this.username;
    }

    public static final /* synthetic */ String access$getBaseUrl$p(Nexus $this) {
        return $this.baseUrl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/vanniktech/maven/publish/nexus/Nexus$Companion;", "", "()V", "CLOSE_WAIT_INTERVAL_MILLIS", "", "PROGRESS_1", "", "PROGRESS_2", "PROGRESS_3", "PROGRESS_4", "PROGRESS_5", "PROGRESS_6", "PROGRESS_7", "nexus"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

