/*
 * Decompiled with CFR 0.152.
 */
package com.notkamui.keval;

import com.notkamui.keval.KevalConstant;
import com.notkamui.keval.KevalFunction;
import com.notkamui.keval.KevalInvalidSymbolException;
import com.notkamui.keval.KevalOperator;
import com.notkamui.keval.TokenType;
import com.notkamui.keval.TokenizerKt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001a\u0010\u0007\u001a\u00020\u0004*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\u0004*\u00020\bH\u0000\u001a,\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r*\b\u0012\u0004\u0012\u00020\b0\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u001a&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\r*\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"SANITIZE_REGEX", "Lkotlin/text/Regex;", "TOKENIZER_REGEX", "shouldAssumeMul", "", "tokenType", "Lcom/notkamui/keval/TokenType;", "isKevalOperator", "", "symbolsSet", "", "isNumeric", "normalizeTokens", "", "Lkotlin/sequences/Sequence;", "symbols", "", "Lcom/notkamui/keval/KevalOperator;", "tokenize", "Keval"})
@SourceDebugExtension(value={"SMAP\nTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tokenizer.kt\ncom/notkamui/keval/TokenizerKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,98:1\n1313#2,2:99\n*S KotlinDebug\n*F\n+ 1 Tokenizer.kt\ncom/notkamui/keval/TokenizerKt\n*L\n17#1:99,2\n*E\n"})
public final class TokenizerKt {
    @NotNull
    private static final Regex SANITIZE_REGEX = new Regex("\\s+");
    @NotNull
    private static final Regex TOKENIZER_REGEX = new Regex("(\\d+\\.\\d+|\\d+|[a-zA-Z_]\\w*|[^\\w\\s])");

    private static final boolean shouldAssumeMul(TokenType tokenType) {
        return tokenType == TokenType.OPERAND || tokenType == TokenType.RPAREN;
    }

    private static final List<String> normalizeTokens(Sequence<String> $this$normalizeTokens, Map<String, ? extends KevalOperator> symbols) {
        int currentPos = 0;
        Ref.ObjectRef prevToken = new Ref.ObjectRef();
        prevToken.element = TokenType.FIRST;
        int parenthesesCount = 0;
        Object[] objectArray = new Integer[]{-1};
        List functionAtCount = CollectionsKt.mutableListOf((Object[])objectArray);
        List ret = new ArrayList();
        Sequence<String> $this$forEach$iv = $this$normalizeTokens;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TokenType it;
            TokenType tokenType;
            Ref.ObjectRef objectRef;
            Ref.ObjectRef objectRef2;
            TokenType tokenType2;
            String token = (String)element$iv;
            boolean bl = false;
            if (TokenizerKt.isNumeric(token) || symbols.get(token) instanceof KevalConstant) {
                TokenType tokenType3 = tokenType2 = TokenType.OPERAND;
                objectRef2 = prevToken;
                boolean bl2 = false;
                if (TokenizerKt.shouldAssumeMul((TokenType)((Object)prevToken.element))) {
                    ret.add("*");
                }
                ret.add(token);
                objectRef = objectRef2;
                tokenType = tokenType2;
            } else if (TokenizerKt.isKevalOperator(token, symbols.keySet())) {
                it = tokenType2 = TokenType.OPERATOR;
                boolean bl3 = false;
                if (TokenizerKt.shouldAssumeMul((TokenType)((Object)prevToken.element)) && (symbols.get(token) instanceof KevalConstant || symbols.get(token) instanceof KevalFunction)) {
                    ret.add("*");
                }
                ret.add(token);
                if (symbols.get(token) instanceof KevalFunction) {
                    functionAtCount.add(parenthesesCount + 1);
                }
                objectRef = objectRef2;
                tokenType = tokenType2;
            } else if (Intrinsics.areEqual((Object)token, (Object)"(")) {
                it = tokenType2 = TokenType.LPAREN;
                boolean bl4 = false;
                ++parenthesesCount;
                if (TokenizerKt.shouldAssumeMul((TokenType)((Object)prevToken.element))) {
                    ret.add("*");
                }
                ret.add(token);
                objectRef = objectRef2;
                tokenType = tokenType2;
            } else if (Intrinsics.areEqual((Object)token, (Object)")")) {
                it = tokenType2 = TokenType.RPAREN;
                boolean bl5 = false;
                --parenthesesCount;
                ret.add(token);
                objectRef = objectRef2;
                tokenType = tokenType2;
            } else if (Intrinsics.areEqual((Object)token, (Object)",")) {
                it = tokenType2 = TokenType.COMMA;
                boolean bl6 = false;
                if (((Number)CollectionsKt.last((List)functionAtCount)).intValue() != parenthesesCount) {
                    throw new KevalInvalidSymbolException(token, SequencesKt.joinToString$default($this$normalizeTokens, (CharSequence)"", null, null, (int)0, null, null, (int)62, null), currentPos, "comma can only be used in the context of a function");
                }
                ret.add(token);
                objectRef = objectRef2;
                tokenType = tokenType2;
            } else {
                throw new KevalInvalidSymbolException(token, SequencesKt.joinToString$default($this$normalizeTokens, (CharSequence)"", null, null, (int)0, null, null, (int)62, null), currentPos, null, 8, null);
            }
            objectRef.element = tokenType;
            currentPos += token.length();
        }
        return ret;
    }

    public static final boolean isNumeric(@NotNull String $this$isNumeric) {
        Intrinsics.checkNotNullParameter((Object)$this$isNumeric, (String)"<this>");
        Double d = StringsKt.toDoubleOrNull((String)$this$isNumeric);
        if (d == null) {
            return false;
        }
        d.doubleValue();
        return true;
    }

    public static final boolean isKevalOperator(@NotNull String $this$isKevalOperator, @NotNull Set<String> symbolsSet) {
        Intrinsics.checkNotNullParameter((Object)$this$isKevalOperator, (String)"<this>");
        Intrinsics.checkNotNullParameter(symbolsSet, (String)"symbolsSet");
        return symbolsSet.contains($this$isKevalOperator);
    }

    @NotNull
    public static final List<String> tokenize(@NotNull String $this$tokenize, @NotNull Map<String, ? extends KevalOperator> symbolsSet) {
        Intrinsics.checkNotNullParameter((Object)$this$tokenize, (String)"<this>");
        Intrinsics.checkNotNullParameter(symbolsSet, (String)"symbolsSet");
        return TokenizerKt.normalizeTokens((Sequence<String>)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)TOKENIZER_REGEX, (CharSequence)$this$tokenize, (int)0, (int)2, null), (Function1)((Function1)tokenize.1.INSTANCE)), (Function1)tokenize.2.INSTANCE), (Function1)tokenize.3.INSTANCE), symbolsSet);
    }

    public static final /* synthetic */ Regex access$getSANITIZE_REGEX$p() {
        return SANITIZE_REGEX;
    }
}

