/*
 * Decompiled with CFR 0.152.
 */
package com.notkamui.keval;

import com.notkamui.keval.BinaryOperatorNode;
import com.notkamui.keval.FunctionNode;
import com.notkamui.keval.GrammarKt;
import com.notkamui.keval.KevalBinaryOperator;
import com.notkamui.keval.KevalBothOperator;
import com.notkamui.keval.KevalConstant;
import com.notkamui.keval.KevalFunction;
import com.notkamui.keval.KevalInvalidExpressionException;
import com.notkamui.keval.KevalOperator;
import com.notkamui.keval.KevalUnaryOperator;
import com.notkamui.keval.Node;
import com.notkamui.keval.UnaryOperatorNode;
import com.notkamui.keval.ValueNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010(\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\b\u0010\u001f\u001a\u00020\u0015H\u0002J\u0014\u0010 \u001a\u00020\u00152\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0010\u0010#\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0006\u0010%\u001a\u00020\u0015J\b\u0010&\u001a\u00020\u0015H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/notkamui/keval/Parser;", "", "tokens", "", "", "tokensToString", "operators", "", "Lcom/notkamui/keval/KevalOperator;", "(Ljava/util/Iterator;Ljava/lang/String;Ljava/util/Map;)V", "currentPos", "", "currentToken", "getCurrentToken", "()Ljava/lang/String;", "currentTokenOrNull", "openParenthesesCount", "consume", "", "expected", "expression", "Lcom/notkamui/keval/Node;", "minPrecedence", "getBinaryOperator", "Lcom/notkamui/keval/KevalBinaryOperator;", "token", "getUnaryOperator", "Lcom/notkamui/keval/KevalUnaryOperator;", "handleBinaryOperator", "node", "handleConstant", "handleFunction", "handleUnaryOperator", "isBinaryOrBoth", "", "isUnaryOrBothPostfix", "isUnaryOrBothPrefix", "parse", "primary", "Keval"})
public final class Parser {
    @NotNull
    private final Iterator<String> tokens;
    @NotNull
    private final String tokensToString;
    @NotNull
    private final Map<String, KevalOperator> operators;
    @Nullable
    private String currentTokenOrNull;
    private int currentPos;
    private int openParenthesesCount;

    public Parser(@NotNull Iterator<String> tokens, @NotNull String tokensToString, @NotNull Map<String, ? extends KevalOperator> operators) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)tokensToString, (String)"tokensToString");
        Intrinsics.checkNotNullParameter(operators, (String)"operators");
        this.tokens = tokens;
        this.tokensToString = tokensToString;
        this.operators = operators;
        this.currentTokenOrNull = this.tokens.next();
    }

    private final String getCurrentToken() {
        String string = this.currentTokenOrNull;
        if (string == null) {
            throw new KevalInvalidExpressionException(this.tokensToString, -1, null, 4, null);
        }
        return string;
    }

    private final void consume(String expected) {
        if (!Intrinsics.areEqual((Object)this.currentTokenOrNull, (Object)expected)) {
            StringBuilder stringBuilder = new StringBuilder().append("expected ").append(expected).append(" but found ");
            String string = this.currentTokenOrNull;
            if (string == null) {
                string = "end of expression";
            }
            throw new KevalInvalidExpressionException(this.tokensToString, this.currentPos, stringBuilder.append(string).toString());
        }
        if (Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)"(")) {
            int n = this.openParenthesesCount;
            this.openParenthesesCount = n + 1;
        } else if (Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)")")) {
            if (this.openParenthesesCount == 0) {
                throw new KevalInvalidExpressionException(this.tokensToString, this.currentPos, "unexpected closing parenthesis");
            }
            int n = this.openParenthesesCount;
            this.openParenthesesCount = n + -1;
        }
        String string = this.currentTokenOrNull;
        this.currentPos += string != null ? string.length() : 0;
        this.currentTokenOrNull = this.tokens.hasNext() ? this.tokens.next() : null;
    }

    private final boolean isBinaryOrBoth(String token) {
        KevalOperator it = this.operators.get(token);
        boolean bl = false;
        return it instanceof KevalBinaryOperator || it instanceof KevalBothOperator;
    }

    private final boolean isUnaryOrBothPrefix(String token) {
        KevalOperator it = this.operators.get(token);
        boolean bl = false;
        return it instanceof KevalUnaryOperator && ((KevalUnaryOperator)it).isPrefix() || it instanceof KevalBothOperator && ((KevalBothOperator)it).getUnary().isPrefix();
    }

    private final boolean isUnaryOrBothPostfix(String token) {
        KevalOperator it = this.operators.get(token);
        boolean bl = false;
        return it instanceof KevalUnaryOperator && !((KevalUnaryOperator)it).isPrefix() || it instanceof KevalBothOperator && !((KevalBothOperator)it).getUnary().isPrefix();
    }

    private final KevalBinaryOperator getBinaryOperator(String token) {
        KevalBinaryOperator kevalBinaryOperator;
        KevalOperator it = this.operators.get(token);
        boolean bl = false;
        if (it instanceof KevalBothOperator) {
            kevalBinaryOperator = ((KevalBothOperator)it).getBinary();
        } else {
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.notkamui.keval.KevalBinaryOperator");
            kevalBinaryOperator = (KevalBinaryOperator)it;
        }
        return kevalBinaryOperator;
    }

    private final KevalUnaryOperator getUnaryOperator(String token) {
        KevalUnaryOperator kevalUnaryOperator;
        KevalOperator it = this.operators.get(token);
        boolean bl = false;
        if (it instanceof KevalBothOperator) {
            kevalUnaryOperator = ((KevalBothOperator)it).getUnary();
        } else {
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.notkamui.keval.KevalUnaryOperator");
            kevalUnaryOperator = (KevalUnaryOperator)it;
        }
        return kevalUnaryOperator;
    }

    private final Node handleBinaryOperator(Node node, int minPrecedence) {
        KevalBinaryOperator op;
        Node result = node;
        while (this.currentTokenOrNull != null && this.isBinaryOrBoth(this.getCurrentToken()) && (op = this.getBinaryOperator(this.getCurrentToken())).getPrecedence() >= minPrecedence) {
            this.consume(this.getCurrentToken());
            int rightAssociativity = op.isLeftAssociative() ? 1 : 0;
            result = new BinaryOperatorNode(result, op.getImplementation(), this.expression(op.getPrecedence() + rightAssociativity));
        }
        return result;
    }

    private final Node handleUnaryOperator(Node node) {
        KevalUnaryOperator op = this.getUnaryOperator(this.getCurrentToken());
        this.consume(this.getCurrentToken());
        Function1<Double, Double> function1 = op.getImplementation();
        Node node2 = node;
        if (node2 == null) {
            node2 = this.primary();
        }
        return new UnaryOperatorNode(function1, node2);
    }

    static /* synthetic */ Node handleUnaryOperator$default(Parser parser, Node node, int n, Object object) {
        if ((n & 1) != 0) {
            node = null;
        }
        return parser.handleUnaryOperator(node);
    }

    private final Node handleFunction() {
        String functionName = this.getCurrentToken();
        this.consume(functionName);
        KevalOperator kevalOperator = this.operators.get(functionName);
        Intrinsics.checkNotNull((Object)kevalOperator, (String)"null cannot be cast to non-null type com.notkamui.keval.KevalFunction");
        KevalFunction op = (KevalFunction)kevalOperator;
        this.consume("(");
        List args = new ArrayList();
        while (!Intrinsics.areEqual((Object)this.currentTokenOrNull, (Object)")")) {
            args.add(Parser.expression$default(this, 0, 1, null));
            if (op.getArity() != null && args.size() > op.getArity()) {
                throw new KevalInvalidExpressionException(this.tokensToString, this.currentPos, "expected " + op.getArity() + ' ' + GrammarKt.access$pluralize("argument", op.getArity()) + " but found " + args.size());
            }
            if (!Intrinsics.areEqual((Object)this.currentTokenOrNull, (Object)",")) continue;
            this.consume(",");
        }
        this.consume(")");
        if (op.getArity() != null && args.size() < op.getArity()) {
            throw new KevalInvalidExpressionException(this.tokensToString, this.currentPos, "expected " + op.getArity() + ' ' + GrammarKt.access$pluralize("argument", op.getArity()) + " but found " + args.size());
        }
        return new FunctionNode(op.getImplementation(), args);
    }

    private final Node handleConstant() {
        KevalOperator kevalOperator = this.operators.get(this.getCurrentToken());
        Intrinsics.checkNotNull((Object)kevalOperator, (String)"null cannot be cast to non-null type com.notkamui.keval.KevalConstant");
        KevalConstant op = (KevalConstant)kevalOperator;
        this.consume(this.getCurrentToken());
        return new ValueNode(op.getValue());
    }

    private final Node expression(int minPrecedence) {
        Node node = this.primary();
        while (this.currentTokenOrNull != null && this.isUnaryOrBothPostfix(this.getCurrentToken())) {
            node = this.handleUnaryOperator(node);
        }
        node = this.handleBinaryOperator(node, minPrecedence);
        return node;
    }

    static /* synthetic */ Node expression$default(Parser parser, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return parser.expression(n);
    }

    private final Node primary() {
        String token;
        if (this.currentTokenOrNull != null && this.isUnaryOrBothPrefix(this.getCurrentToken())) {
            return Parser.handleUnaryOperator$default(this, null, 1, null);
        }
        if (Intrinsics.areEqual((Object)this.currentTokenOrNull, (Object)"(")) {
            this.consume("(");
            Node node = Parser.expression$default(this, 0, 1, null);
            this.consume(")");
            return node;
        }
        if (this.operators.containsKey(this.currentTokenOrNull)) {
            KevalOperator op = this.operators.get(this.getCurrentToken());
            if (op instanceof KevalFunction) {
                return this.handleFunction();
            }
            if (op instanceof KevalConstant) {
                return this.handleConstant();
            }
        }
        if (!GrammarKt.access$isDouble(token = this.getCurrentToken())) {
            throw new KevalInvalidExpressionException(this.tokensToString, this.currentPos, "expected number or symbol but found " + token);
        }
        this.consume(this.getCurrentToken());
        ValueNode node = new ValueNode(Double.parseDouble(token));
        return node;
    }

    @NotNull
    public final Node parse() {
        Node node = Parser.expression$default(this, 0, 1, null);
        if (this.currentTokenOrNull != null) {
            throw new KevalInvalidExpressionException(this.tokensToString, this.currentPos, "unexpected token " + this.currentTokenOrNull);
        }
        return node;
    }
}

