/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.mixinconstraints.util;

import com.moulberry.mixinconstraints.util.Pair;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedSet;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.mixin.transformer.ext.extensions.ExtensionCheckClass;

public final class MixinHacks {
    private static MethodHandle TARGET_CLASS_CONTEXT_MIXINS;
    private static MethodHandle MIXIN_INFO_GET_STATE;
    private static MethodHandle STATE_CLASS_NODE;
    private static MethodHandle EXTENSIONS_EXTENSIONS;
    private static MethodHandle EXTENSIONS_ACTIVE_EXTENSIONS_GET;
    private static MethodHandle EXTENSIONS_ACTIVE_EXTENSIONS_SET;
    private static boolean initialized;

    private static void tryInit() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            Class<?> TargetClassContext = Class.forName("org.spongepowered.asm.mixin.transformer.TargetClassContext");
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(TargetClassContext, MethodHandles.lookup());
            TARGET_CLASS_CONTEXT_MIXINS = lookup.findGetter(TargetClassContext, "mixins", SortedSet.class);
            Class<?> MixinInfo = Class.forName("org.spongepowered.asm.mixin.transformer.MixinInfo");
            Class<?> MixinInfo$State = Class.forName("org.spongepowered.asm.mixin.transformer.MixinInfo$State");
            lookup = MethodHandles.privateLookupIn(MixinInfo, MethodHandles.lookup());
            MIXIN_INFO_GET_STATE = lookup.findVirtual(MixinInfo, "getState", MethodType.methodType(MixinInfo$State));
            lookup = MethodHandles.privateLookupIn(MixinInfo$State, MethodHandles.lookup());
            STATE_CLASS_NODE = lookup.findGetter(MixinInfo$State, "classNode", ClassNode.class);
            lookup = MethodHandles.privateLookupIn(Extensions.class, MethodHandles.lookup());
            EXTENSIONS_EXTENSIONS = lookup.findGetter(Extensions.class, "extensions", List.class);
            EXTENSIONS_ACTIVE_EXTENSIONS_GET = lookup.findGetter(Extensions.class, "activeExtensions", List.class);
            EXTENSIONS_ACTIVE_EXTENSIONS_SET = lookup.findSetter(Extensions.class, "activeExtensions", List.class);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerMixinExtension(IExtension extension) {
        MixinHacks.tryInit();
        try {
            Extensions extensions = (Extensions)((IMixinTransformer)MixinEnvironment.getDefaultEnvironment().getActiveTransformer()).getExtensions();
            MixinHacks.addExtension(EXTENSIONS_EXTENSIONS.invokeExact(extensions), extension);
            ArrayList<IExtension> activeExtensions = new ArrayList<IExtension>(EXTENSIONS_ACTIVE_EXTENSIONS_GET.invokeExact(extensions));
            MixinHacks.addExtension(activeExtensions, extension);
            EXTENSIONS_ACTIVE_EXTENSIONS_SET.invokeExact(extensions, Collections.unmodifiableList(activeExtensions));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static List<Pair<IMixinInfo, ClassNode>> getMixinsFor(ITargetClassContext context) {
        MixinHacks.tryInit();
        ArrayList<Pair<IMixinInfo, ClassNode>> result = new ArrayList<Pair<IMixinInfo, ClassNode>>();
        try {
            for (IMixinInfo mixin : TARGET_CLASS_CONTEXT_MIXINS.invoke(context)) {
                ClassNode classNode = STATE_CLASS_NODE.invoke(MIXIN_INFO_GET_STATE.invoke(mixin));
                result.add(Pair.of(mixin, classNode));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private static void addExtension(List<IExtension> extensions, IExtension newExtension) {
        extensions.add(0, newExtension);
        ArrayList<IExtension> lateExtensions = new ArrayList<IExtension>();
        ListIterator<IExtension> it = extensions.listIterator();
        while (it.hasNext()) {
            IExtension extension = it.next();
            if (!(extension instanceof ExtensionCheckClass)) continue;
            it.remove();
            lateExtensions.add(extension);
        }
        extensions.addAll(lateExtensions);
    }

    static {
        initialized = false;
    }
}

