/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.mixinconstraints.util;

import com.moulberry.mixinconstraints.MixinConstraints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Abstractions {
    private static List<Abstractions> abstractions = null;

    private static boolean doesClassExist(String className) {
        try {
            Class.forName(className, false, MixinConstraints.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private static List<Abstractions> getAbstractions() {
        if (abstractions == null) {
            Abstractions instance;
            abstractions = new ArrayList<Abstractions>();
            String name = System.getProperty("mixinconstraints.abstraction");
            if (name != null && !name.isBlank() && (instance = Abstractions.tryLoadAbstractionsFromClassname(name)) != null) {
                abstractions.add(instance);
            }
            if (Abstractions.doesClassExist("net.neoforged.fml.loading.FMLLoader") && (instance = Abstractions.tryLoadAbstractionsFromClassname("com.moulberry.mixinconstraints.NeoForgeAbstractionsImpl")) != null) {
                abstractions.add(instance);
            }
            if (Abstractions.doesClassExist("net.minecraftforge.fml.loading.FMLLoader") && (instance = Abstractions.tryLoadAbstractionsFromClassname("com.moulberry.mixinconstraints.ForgeAbstractionsImpl")) != null) {
                abstractions.add(instance);
            }
            if (Abstractions.doesClassExist("net.fabricmc.loader.api.FabricLoader") && (instance = Abstractions.tryLoadAbstractionsFromClassname("com.moulberry.mixinconstraints.FabricAbstractionsImpl")) != null) {
                abstractions.add(instance);
            }
            if (abstractions.isEmpty()) {
                throw new RuntimeException("Could not determine loader");
            }
        }
        return abstractions;
    }

    private static Abstractions tryLoadAbstractionsFromClassname(String name) {
        try {
            return Class.forName(name).asSubclass(Abstractions.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            MixinConstraints.LOGGER.error("Failed to load {}", (Object)name, (Object)e);
            return null;
        }
    }

    public static boolean isDevelopmentEnvironment() {
        for (Abstractions instance : Abstractions.getAbstractions()) {
            if (!instance.isDevEnvironment()) continue;
            return true;
        }
        return false;
    }

    public static boolean isModLoadedWithinVersion(String modId, String minVersion, String maxVersion) {
        for (Abstractions instance : Abstractions.getAbstractions()) {
            String version = instance.getModVersion(modId);
            if (version == null || !instance.isVersionInRange(version, minVersion, maxVersion)) continue;
            return true;
        }
        return false;
    }

    public static String getLoaderName() {
        Iterator<Abstractions> iterator = Abstractions.getAbstractions().iterator();
        if (iterator.hasNext()) {
            Abstractions instance = iterator.next();
            return instance.getPlatformName();
        }
        throw new RuntimeException("Could not determine loader");
    }

    protected abstract boolean isDevEnvironment();

    protected abstract String getModVersion(String var1);

    protected abstract boolean isVersionInRange(String var1, String var2, String var3);

    protected abstract String getPlatformName();
}

