/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.mixinconstraints.checker;

import com.moulberry.mixinconstraints.util.Abstractions;

public class ConstraintChecker {
    public static boolean checkModLoaded(String main, Iterable<String> aliases, String minVersion, String maxVersion) {
        if (ConstraintChecker.isModLoadedWithinVersion(main, minVersion, maxVersion)) {
            return true;
        }
        for (String modId : aliases) {
            if (!ConstraintChecker.isModLoadedWithinVersion(modId, minVersion, maxVersion)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkModAbsent(String main, Iterable<String> modIds, String minVersion, String maxVersion) {
        return !ConstraintChecker.checkModLoaded(main, modIds, minVersion, maxVersion);
    }

    public static boolean checkDevEnvironment() {
        return Abstractions.isDevelopmentEnvironment();
    }

    public static boolean checkMinecraftVersion(String minVersion, String maxVersion) {
        return ConstraintChecker.isModLoadedWithinVersion("minecraft", minVersion, maxVersion);
    }

    private static boolean isModLoadedWithinVersion(String modId, String minVersion, String maxVersion) {
        return Abstractions.isModLoadedWithinVersion(modId, minVersion, maxVersion);
    }
}

