/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.mixinconstraints;

import com.moulberry.mixinconstraints.checker.AnnotationChecker;
import com.moulberry.mixinconstraints.util.Abstractions;
import java.io.IOException;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.service.MixinService;

public class MixinConstraints {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mixinconstraints");
    public static final boolean VERBOSE = "true".equals(System.getProperty("mixinconstraints.verbose"));

    public static boolean shouldApplyMixin(String mixinClassName) {
        try {
            ClassNode classNode = MixinService.getService().getBytecodeProvider().getClassNode(mixinClassName);
            if (VERBOSE) {
                LOGGER.info("Checking class-level mixin constraints for {}", (Object)mixinClassName);
            }
            if (classNode.visibleAnnotations != null) {
                for (AnnotationNode node : classNode.visibleAnnotations) {
                    if (AnnotationChecker.checkAnnotationNode(node)) continue;
                    if (VERBOSE) {
                        LOGGER.warn("Preventing application of mixin {} due to failing constraint", (Object)mixinClassName);
                    }
                    return false;
                }
            }
            return true;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return MixinConstraints.shouldApplyMixin(mixinClassName);
    }

    public static String getLoaderName() {
        return Abstractions.getLoaderName();
    }

    @Deprecated
    public static Loader getLoader() {
        return switch (Abstractions.getLoaderName()) {
            case "Forge" -> Loader.FORGE;
            case "NeoForge" -> Loader.NEOFORGE;
            case "Fabric" -> Loader.FABRIC;
            default -> Loader.CUSTOM;
        };
    }

    public static enum Loader {
        FORGE,
        NEOFORGE,
        FABRIC,
        CUSTOM;


        public String toString() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case FORGE -> "Forge";
                case NEOFORGE -> "NeoForge";
                case FABRIC -> "Fabric";
                case CUSTOM -> MixinConstraints.getLoaderName();
            };
        }
    }
}

